// $Id: CVstMidiEventList.cpp,v 1.5 2007/02/08 21:08:23 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
 */

#include "CVstMidiEventList.hpp"
#include <Testing/CTrace.hpp>
using Exponent::Testing::CTrace;
using Exponent::Vst::CVstMidiEventList;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CVstMidiEventList, CMidiEventList);

//	===========================================================================
CVstMidiEventList::CVstMidiEventList()
{
	EXPONENT_CLASS_CONSTRUCTION(CVstMidiEventList);
}

//	===========================================================================
CVstMidiEventList::~CVstMidiEventList()
{
	EXPONENT_CLASS_DESTRUCTION(CVstMidiEventList);
}

//	===========================================================================
void CVstMidiEventList::addFromVSTEvent(VstEvents *events)
{
	// Loop through the array and deal with each event
	for (long i = 0; i < events->numEvents && m_numberOfEvents < CMIDI_EVENT_LIST_MAX_EVENTS; i++)
	{
		// Check that the event is of the right type
		if (events->events[i]->type != kVstMidiType)
		{
			continue;
		}

		// Store the event
		const VstMidiEvent *theEvent = (VstMidiEvent *)events->events[i];

		// Get midi data, delta time, status and channel
		const char* midiData = theEvent->midiData;
		const long delta	 = theEvent->deltaFrames;
		const long status    = midiData[0] & CMidi::CMIDI_STATUS_MASK;
		const long channel   = midiData[0] & CMidi::CMIDI_CHANNEL_MASK;

		// Check the message is on the correct channel
		if (channel != m_midiChannel)
		{
			continue;
		}

		// Add the event
		switch(status)
		{
			case CMidi::CMIDI_NOTE_ON:
			case CMidi::CMIDI_NOTE_OFF:
				{
					const long note     = midiData[1] & CMidi::CMIDI_VALUE_MASK;
					const long velocity = midiData[2] & CMidi::CMIDI_VALUE_MASK;
					m_list[m_numberOfEvents++].setEvent(status, note, velocity, channel, delta);
				}
			break;
			case CMidi::CMIDI_CONTROL_CHANGE:
				if (midiData[1] == CMidi::CMIDI_MONO_MODE_ON || midiData[1] == CMidi::CMIDI_ALL_NOTES_OFF)
				{
					m_list[m_numberOfEvents++].setEvent(CMidi::CMIDI_ALL_NOTES_OFF, 0, 0, channel, delta);
				}
				else
				{
					const long controller = midiData[1] & CMidi::CMIDI_VALUE_MASK;
					const long value      = midiData[2] & CMidi::CMIDI_VALUE_MASK;
					m_list[m_numberOfEvents++].setEvent(status, controller, value, channel, delta);
				}
			break;
			case CMidi::CMIDI_PITCH_BEND:
				m_list[m_numberOfEvents].setTimeDelta(delta);
				m_list[m_numberOfEvents].setValue(0);
				m_list[m_numberOfEvents].setSubValue(0);
				m_list[m_numberOfEvents].setPitchBend(((double)(((unsigned char)midiData[1]) + (((unsigned char)midiData[2]) << 7)) / (double)0x2000) - 1.0);
				m_list[m_numberOfEvents++].setStatus(status);		// Notice that we increment the event count on this one but not the others 
			break;
		}
	}
}